<?php
require_once 'db.php';

// Helper
function safe($key) {
    return isset($_POST[$key]) ? htmlspecialchars(trim($_POST[$key])) : '';
}

// Values
$member_number       = (int) safe('member_number');
$first_name          = safe('first_name');
$middle_name         = safe('middle_name');
$surname             = safe('surname');
$joined              = date('Y-m-d');
$paid_amount         = '';
$paid_date           = '';
$expiry_date         = '';
$notes               = '';
$phone               = safe('phone');
$next_of_kin         = safe('next_of_kin');
$relationship        = safe('relationship');
$next_of_kin_phone   = safe('kin_contact');
$payment_status      = 'Due';
$email               = safe('email');
$password            = null;
$gender              = safe('gender');
$dob                 = safe('dob');
$medical_condition   = safe('medical_condition');
$current_medication  = safe('current_medication');
$permission          = safe('permission');
$photo = '';
if (!empty($_POST['photo_capture'])) {
    $data = $_POST['photo_capture'];
    if (preg_match('/^data:image\/jpeg;base64,/', $data)) {
        $data = substr($data, strlen('data:image/jpeg;base64,'));
        $data = str_replace(' ', '+', $data);
        $imageData = base64_decode($data);

        $photoName = 'photo_' . time() . '_' . rand(1000,9999) . '.jpg';
        $photoPath = __DIR__ . '/admin/uploads/' . $photoName;

        if (file_put_contents($photoPath, $imageData)) {
            $photo = '' . $photoName;
        }
    }
}

$questions = [];
for ($i = 1; $i <= 11; $i++) {
    $questions["q$i"] = safe("q$i");
}
$other_info          = safe('other_info');
$waiver_print_name   = safe('waiver_print_name');
$signature_data1     = $_POST['signature_data1'] ?? '';
$signature_data2     = $_POST['signature_data2'] ?? '';
$signature_date      = safe('signature_date');
$nfc_uid             = '';
$membership_type     = 'Pending';
$banned              = 'No';
$address             = safe('address');

// Prepare insert
$stmt = $conn->prepare("
INSERT INTO members (
    first_name, middle_name, surname, joined, paid_amount, paid_date, expiry_date,
    notes, phone, next_of_kin, relationship, next_of_kin_phone, payment_status,
    email, password, gender, dob, medical_condition, current_medication,
    permission, q1, q2, q3, q4, q5, q6, q7, q8, q9, q10, q11,
    other_info, waiver_print_name, signature_data1, signature_data2, signature_date,
    nfc_uid, photo, membership_type, banned, member_number, address
) VALUES (
    ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
)
");

$stmt->bind_param(
    "sssssssssssssssssssssssssssssssssssssssssi",
    $first_name, $middle_name, $surname, $joined, $paid_amount, $paid_date, $expiry_date,
    $notes, $phone, $next_of_kin, $relationship, $next_of_kin_phone, $payment_status,
    $email, $password, $gender, $dob, $medical_condition, $current_medication,
    $permission,
    $questions['q1'], $questions['q2'], $questions['q3'], $questions['q4'], $questions['q5'],
    $questions['q6'], $questions['q7'], $questions['q8'], $questions['q9'], $questions['q10'],
    $questions['q11'],
    $other_info, $waiver_print_name, $signature_data1, $signature_data2, $signature_date,
    $nfc_uid, $photo, $membership_type, $banned, $member_number, $address
);

// Execute
if ($stmt->execute()) {
    header("Location: register_success.php");
    exit();
} else {
    echo "Error: " . $stmt->error;
}
?>
